' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports System.Drawing.Imaging

''' <summary>
''' Klasa Helpers dostarcza kilku metodu uytkowych wykorzystywanych w ramach witryny.
''' </summary>
Public Class Helpers

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy Helpers.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Skaluje obraz do okrelonej maksymalnej szerokoci
  ''' </summary>
  ''' <param name="fileNameIn">Pena cieka do obrazu, ktry ma by przeskalowany.</param>
  ''' <param name="fileNameOut">Pena cieka do miniaturki, ktra ma by stworzona.</param>
  ''' <param name="maxWidthOrHeight">Maksymalna szeroko obrazu.</param>
  ''' <remarks>Jesli <paramref name="fileNameIn" /> odpowiada <paramref name="fileNameOut" /> orygina jest nadpisywany.</remarks>
  Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal maxWidthOrHeight As Integer)
    Dim portrait As Boolean = False
    Dim bmpSource As Bitmap = Nothing

    ' Otwrz obraz
    bmpSource = New Bitmap(fileNameIn)

    Dim originalSize As Size = bmpSource.Size
    Dim newSize As Size = New Size(0, 0)

    bmpSource.Dispose()

    Dim maxHeightDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)
    Dim maxWidthAsDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)

    Dim resizeFactor As Decimal

    If (originalSize.Height > originalSize.Width) Then
      ' Orientacja pionowa
      resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Height, maxHeightDecimal))
      newSize.Height = maxWidthOrHeight
      newSize.Width = Convert.ToInt32(originalSize.Width / resizeFactor)
    Else
      ' Orientacja pozioma lub kwadrat
      resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Width, maxWidthAsDecimal))
      newSize.Width = maxWidthOrHeight
      newSize.Height = Convert.ToInt32(originalSize.Height / resizeFactor)
    End If

    Dim mySourceBitmap As Bitmap = Nothing
    Dim myTargetBitmap As Bitmap = Nothing
    Dim myGraphics As Graphics = Nothing

    Try
      mySourceBitmap = New Bitmap(fileNameIn)

      Dim newWidth As Integer = newSize.Width
      Dim newHeight As Integer = newSize.Height

      myTargetBitmap = New Bitmap(newWidth, newHeight)

      myGraphics = Graphics.FromImage(myTargetBitmap)

      myGraphics.InterpolationMode = _
                System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic

      myGraphics.DrawImage(mySourceBitmap, New Rectangle(0, 0, newWidth, newHeight))
      mySourceBitmap.Dispose()

      ' Zapisz nowy obraz
      myTargetBitmap.Save(fileNameOut, ImageFormat.Jpeg)
    Catch
      Throw
    Finally
      If (myGraphics IsNot Nothing) Then
        myGraphics.Dispose()
      End If
      If mySourceBitmap IsNot Nothing Then
        mySourceBitmap.Dispose()
      End If
      If myTargetBitmap IsNot Nothing Then
        myTargetBitmap.Dispose()
      End If
    End Try

  End Sub

#End Region

End Class
